#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int len(const char *args) {
    return strlen(args);
}

void split(const char *s, char c, char ***result, int *count) {
    *count = 0;
    char *p = (char *)s;
    while (*p) {
        if (*p != c) {
            (*count)++;
            while (*p && *p != c)
                p++;
        } else {
            p++;
        }
    }

    *result = (char **)malloc((*count) * sizeof(char *));
    p = (char *)s;
    for (int i = 0; i < *count; i++) {
        while (*p && *p == c)
            p++;
        const char *start = p;
        while (*p && *p != c)
            p++;
        size_t len = p - start;
        (*result)[i] = (char *)malloc((len + 1) * sizeof(char));
        strncpy((*result)[i], start, len);
        (*result)[i][len] = '\0';
    }
}

int main() {
    char linha[100];
    int v = -1, a = -1, b = -1, c = -1;
    while (1) {
        fgets(linha, sizeof(linha), stdin);
        linha[strlen(linha) - 1] = '\0';  

        if (strcmp(linha, "0") == 0) {
            break;
        }

        char **temp;
        int count;
        split(linha, ' ', &temp, &count);

        v = atoi(temp[0]);
        a = atoi(temp[1]);
        b = atoi(temp[2]);
        c = atoi(temp[3]);

        int resp = 0;
        if (v >= a || v >= b || v >= c)
            resp = 1;
        if (v >= (a + b) || v >= (a + c) || v >= (b + c))
            resp = 2;
        if (v >= (a + b + c))
            resp = 3;

        printf("%d\n", resp);

        for (int i = 0; i < count; i++) {
            free(temp[i]);
        }
        free(temp);
    }

    return 0;
}